<?php

namespace Database\Seeders;

use App\Models\Modul;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ModulSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $modulData = [
            [
                'kode' => 'BNS',
                'judul' => 'PROMO BULAN RAMADHAN',
                'isi' => 'isi',
                'link' => 'list-produk?cari=masukan nama / kategori produk (contoh )',
                'gambar' => 'giOhlXBjSazDHxQVKx7Adj0V3ahOuvk0GFqEOjbg.jpg',
                'status' => 'Y',
            ],
            [
                'kode' => 'BNS',
                'judul' => 'Popok Murah',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'dxh3hpL91P3JUoZkjyu0Xy6zYEee837fB74SrB54.jpg',
                'status' => 'Y',
            ],
            [
                'kode' => 'BNS',
                'judul' => 'Ongkir',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'cmTEU37agJiC7kmZ2FqFLc4q2EVOquWa1rqjAzyj.jpg',
                'status' => 'Y',
            ],
            // BNA
            [
                'kode' => 'BNA',
                'judul' => 'judul',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'GV1drkfKyI7fGduihoie79kojHU9antYqJwA2v3F.jpg',
                'status' => 'Y',
            ],
            [
                'kode' => 'BNA',
                'judul' => 'judul',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'DJbc7SHF6pnMomVnhuK0BFMnQGiMB2zklbKJPWrM.jpg',
                'status' => 'Y',
            ],
            // BNB
            [
                'kode' => 'BNB',
                'judul' => 'judul',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'DaEXoRYixEXRxl7kIYXMc7LNNUkJ8JSqYy6XXLxr.jpg',
                'status' => 'Y',
            ],
            [
                'kode' => 'BNB',
                'judul' => 'judul',
                'isi' => 'isi',
                'link' => '#',
                'gambar' => 'sa4Yd7ai2LpLnsieZhFkfQozqxm5aBay8jgu4DyQ.jpg',
                'status' => 'Y',
            ],
            // DISC
            [
                'kode' => 'DISC',
                'judul' => 'Promo',
                'isi' => '10',
                'link' => '-',
                'gambar' => '-',
                'status' => 'N',
                'tgl1' => date('Y-m-d H:i:s'),
                'tgl2' => date('Y-m-d H:i:s'),
            ],
            // POIN
            [
                'kode' => 'POIN',
                'judul' => '50000',
                'isi' => '1',
                'link' => '-',
                'gambar' => '-',
                'status' => 'Y',
            ],
            // PRINT
            [
                'kode' => 'PRINT',
                'judul' => '-',
                'isi' => 'POS58',
                'link' => '-',
                'gambar' => '-',
                'status' => 'N',
            ],
            // PNT
            [
                'kode' => 'PNT',
                'judul' => 'Nama Toko',
                'isi' => 'Alamat Toko',
                'link' => 'Hp toko',
                'gambar' => 'email@gmail.com',
                'status' => 'Y',
            ],
            // PTX
            [
                'kode' => 'PTX',
                'judul' => '**Terimakasih telah berbelanja**',
                'isi' => 'Barang yang sudah dibeli  tidak bisa ditukar/kembalikan',
                'link' => 'Layanan belanaja online www.minimarket.online',
                'gambar' => 'Kota kabupaten',
                'status' => 'Y',
            ],
            // BANK
            [
                'kode' => 'BANK',
                'judul' => 'BNI',
                'isi' => '0852354425',
                'link' => 'minimarket online',
                'gambar' => '',
                'status' => 'Y',
            ],
            [
                'kode' => 'BANK',
                'judul' => 'DANA',
                'isi' => '0852354425',
                'link' => 'minimarket online',
                'gambar' => '',
                'status' => 'Y',
            ],
            [
                'kode' => 'BANK',
                'judul' => 'OVO',
                'isi' => '0852354425',
                'link' => 'minimarket online',
                'gambar' => '',
                'status' => 'Y',
            ],
            // PFTG
            [
                'kode' => 'PFTG',
                'judul' => 'Tentang Kami',
                'isi' => 'isi',
                'link' => '',
                'gambar' => '',
                'status' => 'Y',
            ],
            // PFLY
            [
                'kode' => 'PFLY',
                'judul' => 'Layanan di toko kami',
                'isi' => '1. Dapat ngopi gratis 2. WF gratis',
                'link' => '',
                'gambar' => '',
                'status' => 'Y',
            ],
            // PFKT
            [
                'kode' => 'PFKT',
                'judul' => '081256568989',
                'isi' => 'toko@gmail.com',
                'link' => 'Jl. Gajah Mada, Kali Nilam, Kec. Delta Pawan, Kabupaten Ketapang, Kalimantan Barat 78112',
                'gambar' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15951.352483472396!2d109.9628238!3d-1.805234!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e0519006ad824a5%3A0x41d6a26f826853e!2sToko%20langgeng%20jaya%202!5e0!3m2!1sid!2sid!4v1747991029220!5m2!1sid!2sid" width="100%" height="230" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>',
                'status' => 'Y',
            ]
        ];

        foreach ($modulData as $key => $value) {
            Modul::create($value);
        }
    }
}
